% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vioplotW.R
\name{vioplotW}
\alias{vioplotW}
\title{Violin-plots version W}
\usage{
vioplotW(
  x,
  ...,
  finiteOnly = TRUE,
  range = 1.5,
  hh = NULL,
  ylim = NULL,
  nameSer = NULL,
  horizontal = FALSE,
  col = "rainbow",
  border = "black",
  lty = 1,
  tit = NULL,
  las = 1,
  lwd = 1,
  rectCol = "black",
  colMed = "white",
  pchMed = 19,
  at = 0,
  add = FALSE,
  wex = 1,
  drawRect = TRUE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(matrix, list or data.frame) data to plot, or first series of data}

\item{...}{(numeric) additional sets of data to plot}

\item{finiteOnly}{(logical) eliminate non-finite elements to avoid potential errors (eg when encountering \code{NA})}

\item{range}{(numerical) custom range}

\item{hh}{(numeric) a vector of length one, two or three, defining the smoothing parameter (standard deviation to kernel function, if omited anormal optimal smoothing parameter is used); equivalent to argument \code{h} in \code{\link[vioplot]{vioplot}}; see also \code{\link[sm]{sm.density}}}

\item{ylim}{(numeric, length=2) custom limit on y-axis, see also \code{\link[graphics]{par}}}

\item{nameSer}{(character) custom label}

\item{horizontal}{(logical) orientation of plot}

\item{col}{(character or integer) for gradients may be custom colors or  'rainbow', 'grayscale', 'Spectral' or 'Paired'}

\item{border}{(character) custom color for figure border}

\item{lty}{(integer) type of line(s) (see also \code{\link[graphics]{par}})}

\item{tit}{(character) custom title to figure}

\item{las}{(integer) orientation of axis labels (see also \code{\link[graphics]{par}})}

\item{lwd}{(integer) width of line(s) (see also \code{\link[graphics]{par}})}

\item{rectCol}{(character) color of rectangle}

\item{colMed}{(character or integer) color for median (or average) point to show center of group}

\item{pchMed}{(integer) symbol type for center  (see also \code{pch} in \code{\link[graphics]{par}})}

\item{at}{(numeric) custom locoation of data-series names}

\item{add}{(logical) add to existing plot if \code{TRUE}}

\item{wex}{(integer) relative expansion of the violin}

\item{drawRect}{(logical) if \code{TRUE}, draw box}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
figure only
}
\description{
This function allows generating violin-plots using a variety of input formats and offers additional options for colors.   
Code from \href{https://CRAN.R-project.org/package=vioplot}{vioplot} was modified based on a omment on
\href{http://r.789695.n4.nabble.com/Removing-NAs-from-dataframe-for-use-in-Vioplot-td4720274.html}{Nabble} and 
further extended. The package \href{https://CRAN.R-project.org/package=vioplot}{vioplot} does not have to be installed for using this function. 
Main input data may now be matrix of list of multiple data-elements (entries may be of variable length),
individual colors for different sets of data or color-gradients can be specified, and display n per set of data was integtated. 
Note : Arguments have to be given with full names, lazy evaluation of arguments will not work properly with this function (since '...' is used to capture additional data-sets).
}
\examples{
set.seed(2013)
datT6 <- matrix(round(rnorm(300)+3,1),ncol=6,dimnames=list(paste("li",1:50,sep=""),
  letters[19:24]))
vioplotW(datT6)
## variable number of elements (each n is displayed)
datT6b <- apply(datT6,2,function(x) x[which(x <5)])
vioplotW(datT6b,col="Spectral")
}
\seealso{
(the original :) \code{\link[vioplot]{vioplot}}
}
