% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_report.R
\name{generate_report}
\alias{generate_report}
\title{Generate HTML report with list inputs}
\usage{
generate_report(
  title = "My minimal HTML generator",
  filename = "minimal_html",
  outputs = output_list,
  titles,
  subheaders,
  echos,
  levels,
  theme = "united",
  preamble = ""
)
}
\arguments{
\item{title}{Character string to specify the title of the chunk.}

\item{filename}{File name to be used in the exported HTML.}

\item{outputs}{A list of outputs to be added to the HTML report.
Note that \code{outputs}, \code{titles}, \code{echos}, and \code{levels} must have the same
length}

\item{titles}{A list/vector of character strings to specify the title of the
chunks.}

\item{subheaders}{A list/vector of character strings to specify the
subheaders for each chunk.}

\item{echos}{A list/vector of logical values to specify whether to display
code.}

\item{levels}{A list/vector of numeric value to specify the header level of
the chunk.}

\item{theme}{Character vector to specify theme to be used for the report.
E.g. \code{"united"}, \code{"default"}.}

\item{preamble}{A preamble to appear at the beginning of the report, passed
as a text string.}
}
\value{
An HTML report with the same file name as specified in the arguments is
generated in the working directory. No outputs are directly returned by the
function.
}
\description{
This is a support function using a list-pmap workflow to
create a HTML document, using RMarkdown as the engine.
}
\section{Creating a custom report}{


Below is an example on how to set up a custom report.

The first step is to define the content that will go into a report and assign
the outputs to a list.

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Step 1: Define Content
output_list <-
  list(sq_data \%>\% workloads_summary(return = "plot"),
       sq_data \%>\% workloads_summary(return = "table")) \%>\%
  purrr::map_if(is.data.frame, create_dt)
}\if{html}{\out{</div>}}

The next step is to add a list of titles for each of the objects on the list:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Step 2: Add Corresponding Titles
title_list <- c("Workloads Summary - Plot", "Workloads Summary - Table")
n_title <- length(title_list)
}\if{html}{\out{</div>}}

The final step is to run \code{generate_report()}. This can all be wrapped within
a function such that the function can be used to generate a HTML report.

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Step 3: Generate Report
generate_report(title = "My First Report",
                filename = "My First Report",
                outputs = output_list,
                titles = title_list,
                subheaders = rep("", n_title),
                echos = rep(FALSE, n_title
}\if{html}{\out{</div>}}
}

\seealso{
Other Reports: 
\code{\link{IV_report}()},
\code{\link{capacity_report}()},
\code{\link{coaching_report}()},
\code{\link{collaboration_report}()},
\code{\link{connectivity_report}()},
\code{\link{meeting_tm_report}()},
\code{\link{read_preamble}()},
\code{\link{subject_validate_report}()},
\code{\link{validation_report}()},
\code{\link{workpatterns_report}()}
}
\author{
Martin Chan \href{mailto:martin.chan@microsoft.com}{martin.chan@microsoft.com}
}
\concept{Reports}
