% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anonymise.R
\name{anonymise}
\alias{anonymise}
\alias{anonymize}
\title{Anonymise a categorical variable by replacing values}
\usage{
anonymise(x, scramble = FALSE, replacement = NULL)

anonymize(x, scramble = FALSE, replacement = NULL)
}
\arguments{
\item{x}{Character vector to be passed through.}

\item{scramble}{Logical value determining whether to randomise values in the
categorical variable.}

\item{replacement}{Character vector containing the values to replace original
values in the categorical variable. The length of the vector must be at
least as great as the number of unique values in the original variable.
Defaults to \code{NULL}, where the replacement would consist of \code{"Team A"},
\code{"Team B"}, etc.}
}
\description{
Anonymize categorical variables such as HR variables by replacing values with
dummy team names such as 'Team A'. The behaviour is to make 1 to 1
replacements by default, but there is an option to completely randomise
values in the categorical variable.
}
\examples{
unique(anonymise(sq_data$Organization))

rep <- c("Manager+", "Manager", "IC")
unique(anonymise(sq_data$Layer), replacement = rep)

}
\seealso{
jitter
}
