% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_report2.R
\name{generate_report2}
\alias{generate_report2}
\title{Generate HTML report based on existing RMarkdown documents}
\usage{
generate_report2(
  output_format = rmarkdown::html_document(toc = TRUE, toc_depth = 6, theme = "cosmo"),
  output_file = "report.html",
  output_dir = getwd(),
  report_title = "Report",
  rmd_dir = system.file("rmd_template/minimal.rmd", package = "wpa"),
  ...
)
}
\arguments{
\item{output_format}{output format in \code{rmarkdown::render()}. Default is
\code{rmarkdown::html_document(toc = TRUE, toc_depth = 6, theme = "cosmo")}.}

\item{output_file}{output file name in \code{rmarkdown::render()}. Default is
\code{"report.html"}.}

\item{output_dir}{output directory for report in \code{rmarkdown::render()}.
Default is user's current directory.}

\item{report_title}{report title. Default is \code{"Report"}.}

\item{rmd_dir}{string specifying the path to the directory containing the
RMarkdown template files.}

\item{\dots}{other arguments to be passed to \code{params}. For instance, pass
\code{hrvar} if the RMarkdown document requires a 'hrvar' parameter.}
}
\description{
This is a support function that accepts parameters and creates a HTML
document based on an RMarkdown template. This is an alternative to
\code{generate_report()} which instead creates an RMarkdown document from scratch
using individual code chunks.
}
\note{
The implementation of this function was inspired by the 'DataExplorer'
package by boxuancui, with credits due to the original author.
}
