% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local-dependencies.R
\name{wood_local_dependencies}
\alias{wood_local_dependencies}
\title{Get dependencies of locally available package}
\usage{
wood_local_dependencies(package, paths = .libPaths()[1])
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{paths}{\code{character()}\cr
Paths to local libraries, by default the first element of \code{.libPaths()}. If
equal to \code{"all"}, uses all elements of \code{.libPaths()}.}
}
\value{
A data frame with three columns, all in string format:
\itemize{
\item \code{package} (package name),
\item \code{version} (minimum version requirement or \code{NA} if none),
\item \code{type} (dependency type, e.g. \code{"Imports"}).
}
}
\description{
This function extracts dependencies of the selected package,
searching through specified library paths.
}
\examples{
wood_local_dependencies("woodendesc")
wood_local_dependencies("httr", paths = "all")

}
\seealso{
Functions for local libraries:
\code{\link{wood_local_packages}()},
\code{\link{wood_local_versions}()}

Functions that query package dependencies:
\code{\link{wood_bioc_dependencies}()},
\code{\link{wood_core_dependencies}()},
\code{\link{wood_cran_dependencies}()},
\code{\link{wood_dependencies}()},
\code{\link{wood_github_dependencies}()},
\code{\link{wood_runiverse_dependencies}()},
\code{\link{wood_url_dependencies}()}
}
\concept{dependencies}
\concept{local}
