% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_VFTimeSeries.R
\name{PlotVfTimeSeries}
\alias{PlotVfTimeSeries}
\title{PlotVfTimeSeries}
\usage{
PlotVfTimeSeries(Y, Location, Time,
  main = "Visual field sensitivity time series \\n at each location",
  xlab = "Time from first visit (days)", ylab = "Sensitivity (dB)")
}
\arguments{
\item{Y}{a time series variable to be plotted.}

\item{Location}{a variable corresponding to the location on the visual field
that the time series variable was observed.}

\item{Time}{a variable corresponding to the time that the time series variable
was observed.}

\item{main}{an overall title for the plot.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}
}
\description{
Plots a time series at each location of the Humphrey Field Analyzer-II visual field .
}
\details{
\code{PlotVfTimeSeries} is used in the application of glaucoma progression.
 In each cell is the observed DLS at each location over visits, with the red line
 representing a linear regression trend.
}
\examples{
data(VFSeries)
PlotVfTimeSeries(Y = VFSeries$DLS,
                  Location = VFSeries$Location,
                  Time = VFSeries$Time,
                  main = "Visual field sensitivity time series \\n at each location",
                  xlab = "Days from baseline visit",
                  ylab = "Differential light sensitivity (dB)")


}
\author{
Samuel I. Berchuck
}

