% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scry.R
\name{scry}
\alias{scry}
\title{Initialize the wizaRdry directory structure inside an R project}
\usage{
scry(
  study_alias = NULL,
  path = ".",
  overwrite = FALSE,
  repair = FALSE,
  show_tree = NULL,
  create_project = FALSE,
  examples = FALSE,
  skip_prompt = FALSE
)
}
\arguments{
\item{study_alias}{Character string specifying the short name for the study e.g. impact, capr, sing}

\item{path}{Character string specifying the directory path where the structure should be created.
Defaults to the current working directory.}

\item{overwrite}{Logical. If TRUE, will overwrite existing files. If FALSE (default),
will not replace existing files.}

\item{repair}{Logical. If TRUE, will attempt to repair an incomplete directory structure.
If FALSE, will abort with an error message when encountering an incomplete structure.}

\item{show_tree}{Logical. If TRUE (default on first run), will display a visual file tree.
Set to FALSE to suppress the tree view.}

\item{create_project}{Logical. If TRUE, will create an R project file if one doesn't exist.
If FALSE (default), will not create an R project.}

\item{examples}{Logical. If TRUE (default when not repairing), will create example script templates.
If FALSE (default when repairing), will skip creating example scripts.}

\item{skip_prompt}{Logical. If TRUE, will skip the initial confirmation prompt. Defaults to FALSE.}
}
\value{
Invisible TRUE if successful.
}
\description{
Creates the standard directory structure required for the wizaRdry package to function properly.
This includes folders for data cleaning scripts, NDA submission templates, and temporary outputs.
It can detect and repair incomplete directory structures, and optionally create an R project.
}
\details{
The function creates the following directory structure:
\itemize{
\item clean/
\itemize{
\item mongo/
\item qualtrics/
\item redcap/
}
\item nda/
\itemize{
\item mongo/
\item qualtrics/
\item redcap/
}
\item tmp/
}

It also creates template config.yml and secrets.R files, and optionally an R project file.
}
\examples{
\dontrun{
# Initialize in current directory
scry()

# Repair structure in current directory
scry(repair = TRUE)

# Initialize in a specific directory with an R project
scry("path/to/project", create_project = TRUE, repair = TRUE)

# Skip the tree display
scry(repair = TRUE, show_tree = FALSE)

# Explicitly create example scripts when repairing
scry(repair = TRUE, examples = TRUE)

# Skip the confirmation prompt
scry(skip_prompt = TRUE)
}

}
