% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devices.R
\name{devices}
\alias{devices}
\alias{with_dev}
\alias{with_device}
\alias{with_bmp}
\alias{local_bmp}
\alias{with_cairo_pdf}
\alias{local_cairo_pdf}
\alias{with_cairo_ps}
\alias{local_cairo_ps}
\alias{with_pdf}
\alias{local_pdf}
\alias{with_postscript}
\alias{local_postscript}
\alias{with_svg}
\alias{local_svg}
\alias{with_tiff}
\alias{local_tiff}
\alias{with_xfig}
\alias{local_xfig}
\alias{with_png}
\alias{local_png}
\alias{with_jpeg}
\alias{local_jpeg}
\title{Graphics devices}
\usage{
with_bmp(new, code, ...)

local_bmp(new, ..., .local_envir = parent.frame())

with_cairo_pdf(new, code, ...)

local_cairo_pdf(new, ..., .local_envir = parent.frame())

with_cairo_ps(new, code, ...)

local_cairo_ps(new, ..., .local_envir = parent.frame())

with_pdf(new, code, width, height, onefile, family, title, fonts, version,
  paper, encoding, bg, fg, pointsize, pagecentre, colormodel, useDingbats,
  useKerning, fillOddEven, compress)

local_pdf(new, width, height, onefile, family, title, fonts, version, paper,
  encoding, bg, fg, pointsize, pagecentre, colormodel, useDingbats, useKerning,
  fillOddEven, compress, .local_envir = parent.frame())

with_postscript(new, code, onefile, family, title, fonts, encoding, bg, fg,
  width, height, horizontal, pointsize, paper, pagecentre, print.it, command,
  colormodel, useKerning, fillOddEven)

local_postscript(new, onefile, family, title, fonts, encoding, bg, fg, width,
  height, horizontal, pointsize, paper, pagecentre, print.it, command,
  colormodel, useKerning, fillOddEven, .local_envir = parent.frame())

with_svg(new, code, width = 7, height = 7, pointsize = 12,
  onefile = FALSE, family = "sans", bg = "white",
  antialias = c("default", "none", "gray", "subpixel"))

local_svg(new, width = 7, height = 7, pointsize = 12, onefile = FALSE,
  family = "sans", bg = "white", antialias = c("default", "none", "gray",
  "subpixel"), .local_envir = parent.frame())

with_tiff(new, code, ...)

local_tiff(new, ..., .local_envir = parent.frame())

with_xfig(new, code, onefile = FALSE, encoding = "none",
  paper = "default", horizontal = TRUE, width = 0, height = 0,
  family = "Helvetica", pointsize = 12, bg = "transparent",
  fg = "black", pagecentre = TRUE, defaultfont = FALSE,
  textspecial = FALSE)

local_xfig(new, onefile = FALSE, encoding = "none", paper = "default",
  horizontal = TRUE, width = 0, height = 0, family = "Helvetica",
  pointsize = 12, bg = "transparent", fg = "black", pagecentre = TRUE,
  defaultfont = FALSE, textspecial = FALSE, .local_envir = parent.frame())

with_png(new, code, ...)

local_png(new, ..., .local_envir = parent.frame())

with_jpeg(new, code, ...)

local_jpeg(new, ..., .local_envir = parent.frame())
}
\arguments{
\item{new}{\code{[named character]}\cr New graphics device}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{...}{Additional arguments passed to the graphics device.}

\item{.local_envir}{\code{[environment]}\cr The environment to use for scoping.}

\item{width}{the width of the device in inches.}

\item{height}{the height of the device in inches.}

\item{onefile}{should all plots appear in one file or in separate files?}

\item{family}{one of the device-independent font families,
    \code{"sans"}, \code{"serif"} and \code{"mono"}, or a character
    string specify a font family to be searched for in a
    system-dependent way.
    See, the \sQuote{Cairo fonts} section in the help for \code{\link{X11}}.
  }

\item{title}{title string to embed as the \samp{/Title} field in the
    file.  Defaults to \code{"R Graphics Output"}.}

\item{fonts}{a character vector specifying \R graphics font family
    names for additional fonts which will be included in the PDF file.
    Defaults to \code{NULL}.}

\item{version}{a string describing the PDF version that will be
    required to view the output.  This is a minimum, and will be
    increased (with a warning) if necessary.  Defaults to \code{"1.4"},
    but see \sQuote{Details}.}

\item{paper}{the target paper size.  The choices are
    \code{"a4"}, \code{"letter"}, \code{"legal"} (or \code{"us"}) and
    \code{"executive"} (and these can be capitalized), or \code{"a4r"}
    and \code{"USr"} for rotated (\sQuote{landscape}).
    The default is \code{"special"}, which means that the \code{width}
    and \code{height} specify the paper size.  A further choice is
    \code{"default"}; if this is selected, the
    papersize is taken from the option \code{"papersize"}
    if that is set and as \code{"a4"} if it is unset or empty.
    Defaults to \code{"special"}.
  }

\item{encoding}{the name of an encoding file.  See
    \code{\link{postscript}} for details.  Defaults to \code{"default"}.}

\item{bg}{the initial background colour: can be overridden by setting
    par("bg").}

\item{fg}{the initial foreground color to be used.  Defaults to
   \code{"black"}.}

\item{pointsize}{the default pointsize of plotted text (in big points).}

\item{pagecentre}{logical: should the device region be centred on the
    page? -- is only relevant for \code{paper != "special"}.
    Defaults to \code{TRUE}.}

\item{colormodel}{a character string describing the color model:
    currently allowed values are \code{"srgb"}, \code{"gray"} (or
    \code{"grey"}) and \code{"cmyk"}.  Defaults to \code{"srgb"}.  See section
    \sQuote{Color models}.}

\item{useDingbats}{logical.  Should small circles be rendered
    \emph{via} the Dingbats font?  Defaults to \code{TRUE}, which produces
    smaller and better output.  Setting this to \code{FALSE} can work
    around font display problems in broken PDF viewers: although this
    font is one of the 14 guaranteed to be available in all PDF viewers,
    that guarantee is not always honoured.
    See the \sQuote{Note} for a possible fix for some viewers.
    }

\item{useKerning}{logical.  Should kerning corrections be included in
    setting text and calculating string widths?  Defaults to \code{TRUE}.}

\item{fillOddEven}{logical controlling the polygon fill mode:  see
    \code{\link{polygon}} for details.  Defaults to \code{FALSE}.}

\item{compress}{logical.  Should PDF streams be generated with Flate
    compression?  Defaults to \code{TRUE}.}

\item{horizontal}{the orientation of the printed image, a logical.
    Defaults to true, that is landscape orientation on paper sizes
    with width less than height.}

\item{print.it}{logical: should the file be printed when the device is
    closed?  (This only applies if \code{file} is a real file name.)
    Defaults to false.}

\item{command}{the command to be used for \sQuote{printing}. Defaults
to \code{"default"}, the value of option \code{"printcmd"}. The
length limit is \code{2*PATH_MAX}, typically 8096 bytes on unix systems and
520 bytes on windows.}

\item{antialias}{string, the type of anti-aliasing (if any) to be used;
    defaults to \code{"default"}.}

\item{defaultfont}{logical: should the device use xfig's default
    font?}

\item{textspecial}{logical: should the device set the textspecial flag
  for all text elements. This is useful when generating pstex from xfig
  figures.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
  argument.
}
\description{
Temporarily use a graphics device.
}
\section{Functions}{
\itemize{
\item \code{with_bmp}: BMP device

\item \code{with_cairo_pdf}: CAIRO_PDF device

\item \code{with_cairo_ps}: CAIRO_PS device

\item \code{with_pdf}: PDF device

\item \code{with_postscript}: POSTSCRIPT device

\item \code{with_svg}: SVG device

\item \code{with_tiff}: TIFF device

\item \code{with_xfig}: XFIG device

\item \code{with_png}: PNG device

\item \code{with_jpeg}: JPEG device
}}

\examples{
# dimensions are in inches
with_pdf(file.path(tempdir(), "test.pdf"), width = 7, height = 5,
  plot(runif(5))
)

# dimensions are in pixels
with_png(file.path(tempdir(), "test.png"), width = 800, height = 600,
  plot(runif(5))
)
}
\seealso{
\code{\link{withr}} for examples

\code{\link[grDevices]{Devices}}
}
