% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomSearchTurb.R
\name{RandomSearchTurb}
\alias{RandomSearchTurb}
\title{RandomSearchTurb Randomise the location of a single turbine.}
\usage{
RandomSearchTurb(result, Polygon1, n, Plot, GridMethod, max_dist = 2.2)
}
\arguments{
\item{result}{The resulting matrix of the function 'genAlgo' or
'windfarmGA'.}

\item{Polygon1}{The Polygon for the wind farm area.}

\item{n}{The number of random searches to be perfomed. Default is 20.}

\item{Plot}{Should the random serach be plotted? Default is TRUE}

\item{GridMethod}{Should the polygon be divided into rectangular or
hexagonal grid cells? The default is rectangular grid cells and hexagonal
grid cells are computed when assigning "h" or "hexagon" to this input
variable. The randomly generated points may also be paced outside of 
their hexagon.}

\item{max_dist}{A numeric value multiplied by the rotor radius to perform
collision checks. Default is 2.2}
}
\value{
Returns a list.
}
\description{
Perform a random search for a single turbine, to
further optimize the output of the wind farm layout.
}
\examples{
\donttest{
load(file = system.file("extdata/resultrect.rda", package = "windfarmGA"))
load(file = system.file("extdata/polygon.rda", package = "windfarmGA"))

Res = RandomSearchTurb(result = resultrect, Polygon1 = polygon, n = 10)
RandomSearchPlot(resultRS = Res, result = resultrect, Polygon1 = polygon, best =2)
}
}
\author{
Sebastian Gatscha
}
