% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometricRoadPadPropSearchTable.R
\name{geometricRoadPadPropSearchTable}
\alias{geometricRoadPadPropSearchTable}
\title{Create proportion of area searched table from a road and pad plot}
\usage{
geometricRoadPadPropSearchTable(padRadius, roadWidth, maxSearchDistance,
  mastRadius, annuliWidth = 1, ...)
}
\arguments{
\item{padRadius}{Integer, radius of turbine pad.}

\item{roadWidth}{Integer, width of road leading to turbine pad.}

\item{maxSearchDistance}{Integer, maximum search distance from the turbine.}

\item{mastRadius}{Integer, radius of the turbine mast.}

\item{annuliWidth}{Integer, width of annuli, default is 1.}

\item{...}{Currently ignored.}
}
\value{
Data frame of proportion of area searched for each annulus.  \code{distanceFromTurbine} column represents the outer radius of the annuli.
}
\description{
Calculate area of annulus bisected by 2 parallel lines (e.g. a
  road of a road/pad plot).
}
\details{
Searches are conducted on the road and turbine pad around wind
  turbines for bird and bat fatalities. This function creates a data frame of
  proportion of area searched within each annulus ring.

  The \code{mastRadius} argument is to account for the area taken up by the turbine mast.

  The arguments \code{padRadius}, \code{roadWidth}, \code{mastRadius}, and
  \code{annuliWidth} are all rounded to the nearest integer. The \code{maxSearchDistance}
  is rounded up (ceiling function) to an integer. If half units are needed, then
  convert to a smaller unit. See examples.
}
\examples{

pad <- 10 #meters, turbine pad radius
road <- 4 #meters, width of the road to the turbine pad
maxDistance <- 100 #meters, max distance
mast <- 2 #meters, turbine mast radius

## proportion are area searched at each annulu
propSearch <- geometricRoadPadPropSearchTable(padRadius = pad,
                                              roadWidth = road,
                                              maxSearchDistance = maxDistance,
                                              mastRadius = mast)
head(propSearch, 20)

## if half meter annulus rings are desired:
convert <- 100 # meters * 100 = centimeters

## units in centimeters
propSearchHalfMeter <- geometricRoadPadPropSearchTable(padRadius = pad * convert,
                                              roadWidth = road*convert,
                                              maxSearchDistance = maxDistance * convert,
                                              mastRadius = mast * convert,
                                              annuliWidth = 50) ##50cm = half a meter
head(propSearchHalfMeter, 30)

## convert back to meters
propSearchHalfMeter$distanceFromTurbine <- propSearchHalfMeter$distanceFromTurbine/convert
head(propSearchHalfMeter, 30)
}
\seealso{
geometricRectanglePropSearchTable
}
