\name{wpsupportedgames}
\docType{data}
\alias{wpsupportedgames}
\title{Poker Games Supported by the wildpoker package}
\description{
  This data set shows all supported games (in the rownames) and a brief
  description of each game.  

In the "Misc" column, games listed in parentheses are different
  only in terms of holecards or bidding strategy and can be considered
  identical for the purposes of these game stats
}
\usage{wpsupportedgames}
\format{
A data frame with rownames describing the game and 10 variables:

rowname = name of the game(ngame parameter eg, "Seven Stud Hi-Lo")
  \tabular{rlll}{
  [,1] \tab Type \tab chr \tab "Community" games have community cards, "Stud" games do not \cr
  [,2] \tab Main.Hand \tab chr \tab Victory Conditions for Main Hand (see below) \cr
  [,3] \tab Split.Hand \tab chr \tab Victory Conditions for Split Hand \cr
  [,4] \tab Wildcards \tab chr \tab Wildcards generated by the game variant \cr
  [,5] \tab Deal1 \tab chr \tab cards dealt in first round (5h1c = 5 hole, 1 community) \cr
  [,6] \tab Deal2 \tab chr \tab cards dealt in second round (1u = 1 upcard, 3c = 3 community) \cr
  [,7] \tab Deal3 \tab chr \tab cards dealt in third round (NA = no such round in this game) \cr
  [,8] \tab Deal4 \tab chr \tab cards dealt in third round (NA = no such round in this game) \cr
  [,9] \tab Deal5 \tab chr \tab cards dealt in third round (NA = no such round in this game) \cr
  [,10] \tab Misc \tab chr \tab notes about the game.  A game listed in parentheses is statistically the same. \cr
  }
Win codes:
  \itemize{
    \item HI           = High hand wins, no restrictions
    \item HI - Pair    = High hand wins if it is at least a pair
    \item HI - Flop1   = There are two sets of community cards. Build with 1st
    \item HI - Flop2   = There are two sets of community cards. Build with 2nd
    \item LO - A-5     = Low hand wins, Ace is low, straights/flushes ignored
    \item LO - A-5 8-  = As A-5, but need 8-High or lower to win (usually Hi-Lo)
    \item LO - A-6     = Ace is low, straights/flushes count. Homegame variant.
    \item LO - 2-7     = Ace is high, straights/flushes count
    \item LO - 2-7 9-  = As 2-7, but need 8-High or lower to win (usually Hi-Lo)
  }
Poker Hand Value:  High Card < Pair < 2-Pair < 3-Kind < Straight < Flush < FullHouse < 4-Kind < StrFlush < 5-Kind

Ace can normally be either high or low, and wildcards substitute for any suit or value unless otherwise specified by the poker variant

Wildcards added by the game are in addition to those added using the wcard parameter 
in the wpgame or wpstats functions.
 
Minor variants can be created by adding wildcards.  As an example my group used to play \bold{"Dangerous Queens"}
which was Follow the Queen with Suicide King and One Eyed Jacks wild (the idea
being that the wilcards already followed the queens earlier and were wild, but damaged by the experience)

\bold{Dangerous Queens} would be specified in \bold{wpgame} or \bold{wpstats} as:

 ngame = "Follow the Queen", wcards = c("Suicide King", "One Eyed Jacks") or alternately wcards = c("KH", "JH", "JS") 

If using \bold{wpgraphs} directly, \bold{Dangerous Queens} would use the number of added wildcards instead of specifying the wildcards:

 ngame = "Follow the Queen", wcards =3
}
\source{This data set assembled manually from poker rules}
\references{
\href{http://www.poker.com/game/index.htm}{poker.com} has an excellent reference on game variants which was the 
primary source for games rules not encountered in my own play.
}
\seealso{\code{\link{wpnotsupported}}}
\keyword{datasets}