% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasch_rescale_children.R
\name{rasch_rescale_children}
\alias{rasch_rescale_children}
\title{Rescale score from Rasch Analysis for children to range from 0 to 100}
\usage{
rasch_rescale_children(df, df_nest, vars_group, vars_id)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{df_nest}{a nested tibble that contains the column \code{df_split} with the data split by the categories in the column \code{vars_group}}

\item{vars_group}{a string with the column name identifying grouping variable}

\item{vars_id}{a string with column name uniquely identifying individuals}
}
\value{
a tibble with the data \code{df} or unnested \code{df_nest} and new columns "person_pars" and "rescaled" with the original and rescaled person abilities, ranging from 0 to 100, and filter out any rows with an artificial minimum or maximum
}
\description{
Rescale score from Rasch Analysis for children to range from 0 to 100
}
\seealso{
Other rasch functions: 
\code{\link{rasch_DIF}()},
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_factor}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_mds}()},
\code{\link{rasch_model_children}()},
\code{\link{rasch_model}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_rawscore}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale}()},
\code{\link{rasch_split_age}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}

Other children analysis functions: 
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_model_children}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_split_age}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}
}
\concept{children analysis functions}
\concept{rasch functions}
