% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasch_model_children.R
\name{rasch_model_children}
\alias{rasch_model_children}
\title{Run the multigroup and anchored Rasch Model}
\usage{
rasch_model_children(df, df_nest, vars_metric, vars_group, TAM_model)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{df_nest}{a nested tibble that contains the column \code{df_split} with the data split by the categories in the column \code{vars_group}}

\item{vars_metric}{a character vector of items to use in the Rasch Analysis}

\item{vars_group}{a string with the column name identifying grouping variable}

\item{TAM_model}{a string with the type of IRT model to use, passed to \code{irtmodel} argument of \code{TAM::tam()}. Default is \code{"PCM2"}}
}
\value{
a nested tibble with new columns with the Rasch Models calculated with the \code{TAM} package
}
\description{
Run the multigroup and anchored Rasch Model
}
\seealso{
Other rasch functions: 
\code{\link{rasch_DIF}()},
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_factor}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_mds}()},
\code{\link{rasch_model}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_rawscore}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale_children}()},
\code{\link{rasch_rescale}()},
\code{\link{rasch_split_age}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}

Other children analysis functions: 
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale_children}()},
\code{\link{rasch_split_age}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}
}
\concept{children analysis functions}
\concept{rasch functions}
