% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_unweightedpctn.R
\name{table_unweightedpctn}
\alias{table_unweightedpctn}
\title{Compute unweighted percent and N for multiple variables, disaggregated}
\usage{
table_unweightedpctn(
  df,
  vars_demo,
  group_by_var = NULL,
  spread_by_group_by_var = FALSE,
  group_by_var_sums_to_100 = FALSE,
  add_totals = FALSE
)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{vars_demo}{a character vector of names of variables to calculate percent and N for}

\item{group_by_var}{a string (length 1) with the name of the variable from \code{df} to disaggregate by}

\item{spread_by_group_by_var}{logical determining whether to pass \code{group_by_var} to \code{tidyr::spread()} to give a wide-format tab. Default is FALSE.}

\item{group_by_var_sums_to_100}{logical determining whether percentages sum to 100 along the margin of \code{group_by_var}, if applicable. Default is FALSE.}

\item{add_totals}{logical determinging whether to create total rows or columns (as appropriate) that demonstrate the margin that sums to 100. Default is FALSE.}
}
\value{
A tibble with percent and N for each level of each variable in \code{vars_demo}
}
\description{
Compute unweighted percent and N for multiple variables, disaggregated
}
\examples{
table_unweightedpctn(df_adults, vars_demo = c("sex", "age_cat", "work_cat", "edu_cat"))
table_unweightedpctn(df_adults, vars_demo = c("sex", "age_cat", "work_cat", "edu_cat"), 
group_by_var = "disability_cat")
table_unweightedpctn(df_adults, vars_demo = c("sex", "age_cat", "work_cat", "edu_cat"), 
group_by_var = "disability_cat", spread_by_group_by_var = TRUE)
}
\seealso{
Other table functions: 
\code{\link{table_basicstats}()},
\code{\link{table_weightedpct}()}
}
\concept{table functions}
