% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_smooth_vegetation_residual}
\alias{wbt_smooth_vegetation_residual}
\title{Smooth vegetation residual}
\usage{
wbt_smooth_vegetation_residual(
  input,
  output,
  max_scale = 30,
  dev_threshold = 1,
  scale_threshold = 5,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input digital elevation model (DEM) raster file.}

\item{output}{Name of the output raster file.}

\item{max_scale}{Maximum search neighbourhood radius in grid cells.}

\item{dev_threshold}{DEVmax Threshold.}

\item{scale_threshold}{DEVmax scale threshold.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool can smooth the residual roughness due to vegetation cover in LiDAR DEMs.
}
\keyword{GeomorphometricAnalysis}
