% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_contours_from_raster}
\alias{wbt_contours_from_raster}
\title{Contours from raster}
\usage{
wbt_contours_from_raster(
  input,
  output,
  interval = 10,
  base = 0,
  smooth = 9,
  tolerance = 10,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input surface raster file.}

\item{output}{Output vector contour file.}

\item{interval}{Contour interval.}

\item{base}{Base contour height.}

\item{smooth}{Smoothing filter size (in num. points), e.g. 3, 5, 7, 9, 11.}

\item{tolerance}{Tolerance factor, in degrees (0-45); determines generalization level.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Derives a vector contour coverage from a raster surface.
}
\keyword{GeomorphometricAnalysis}
