% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_ransac_planes}
\alias{wbt_lidar_ransac_planes}
\title{Lidar ransac planes}
\usage{
wbt_lidar_ransac_planes(
  input,
  output,
  radius = 2,
  num_iter = 50,
  num_samples = 5,
  threshold = 0.35,
  model_size = 8,
  max_slope = 80,
  classify = FALSE,
  last_returns = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{output}{Output LiDAR file.}

\item{radius}{Search Radius.}

\item{num_iter}{Number of iterations.}

\item{num_samples}{Number of sample points on which to build the model.}

\item{threshold}{Threshold used to determine inlier points.}

\item{model_size}{Acceptable model size.}

\item{max_slope}{Maximum planar slope.}

\item{classify}{Classify points as ground (2) or off-ground (1).}

\item{last_returns}{Only include last- and only-return points.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a RANSAC analysis to identify points within a LiDAR point cloud that belong to linear planes.
}
\keyword{LiDARTools}
