% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_network_analysis.R
\name{wbt_stream_link_length}
\alias{wbt_stream_link_length}
\title{Stream link length}
\usage{
wbt_stream_link_length(
  d8_pntr,
  linkid,
  output,
  esri_pntr = FALSE,
  zero_background = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{d8_pntr}{Input raster D8 pointer file.}

\item{linkid}{Input raster streams link ID (or tributary ID) file.}

\item{output}{Output raster file.}

\item{esri_pntr}{D8 pointer uses the ESRI style scheme.}

\item{zero_background}{Flag indicating whether a background value of zero should be used.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Estimates the length of each link (or tributary) in a stream network.
}
