% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_files.R
\name{whep_read_file}
\alias{whep_read_file}
\title{Download, cache and read files}
\usage{
whep_read_file(file_alias, type = "parquet", version = NULL)
}
\arguments{
\item{file_alias}{Internal name of the requested file. You can find the
possible values in the \code{alias} column of the \code{\link{whep_inputs}} dataset.}

\item{type}{The extension of the file that must be read. Possible values:
\itemize{
\item \code{parquet}: This is the default value for code efficiency reasons.
\item \code{csv}: Mainly available for those who want a more human-readable option.
If the \code{parquet} version is available, this is useless because this
function already returns the dataset in an \code{R} object, so the origin is
irrelevant, and \code{parquet} is read faster.
}

Saving each file in both formats is for transparency and accessibility
purposes, e.g., having to share the data with non-programmers who can
easily import a CSV into a spreadsheet. You will most likely never have
to set this option manually unless for some reason a file could not be
supplied in e.g. \code{parquet} format but was in another one.}

\item{version}{The version of the file that must be read. Possible values:
\itemize{
\item \code{NULL}: This is the default value. A frozen version is chosen to make
the code reproducible. Each release will have its own frozen versions.
The version is the string that can be found in \code{\link{whep_inputs}} in the
\code{version} column.
\item \code{"latest"}: This overrides the frozen version and instead fetches the
latest one that is available. This might or might not match the frozen
version.
\item Other: A specific version can also be used. For more details read the
\code{version} column information from \code{\link{whep_inputs}}.
}}
}
\value{
A tibble with the dataset. Some information about each dataset can
be found in the code where it's used as input for further processing.
}
\description{
Used to fetch input files that are needed for the package's functions
and that were built in external sources and are too large to include
directly. This is a public function for transparency purposes, so that
users can inspect the original inputs of this package that were not
directly processed here.

If the requested file doesn't exist locally, it is downloaded from a public
link and cached before reading it. This is all implemented using the
\href{https://pins.rstudio.com/index.html}{\code{pins}} package. It supports multiple
file formats and file versioning.
}
\examples{
whep_read_file("read_example")
whep_read_file("read_example", type = "parquet", version = "latest")
whep_read_file(
  "read_example",
  type = "csv",
  version = "20250721T152646Z-ce61b"
)
}
