% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotroc}
\alias{plotroc}
\title{Plot crude and model-based ROC curves}
\usage{
plotroc(densities)
}
\arguments{
\item{densities}{Densities object produced by \code{\link{Wdensities}}.}
}
\value{
A ggplot object representing crude and model-based ROC curves.
}
\description{
While the crude ROC curve can be non-concave and is generally not smooth,
the model-based ROC curve is always concave, as the corresponding densities
have been adjusted to be mathematically consistent.
}
\examples{
data("cleveland")
densities <- with(cleveland, Wdensities(y, posterior.p, prior.p))
plotroc(densities)

}
