% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_player.R
\name{wnba_playervsplayer}
\alias{wnba_playervsplayer}
\title{\strong{Get WNBA Stats API Player vs Player}}
\usage{
wnba_playervsplayer(
  date_from = "",
  date_to = "",
  game_segment = "",
  last_n_games = 0,
  league_id = "10",
  location = "",
  measure_type = "Base",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  pace_adjust = "N",
  per_mode = "Totals",
  period = 0,
  player_id = "1628932",
  plus_minus = "N",
  rank = "N",
  season = most_recent_wnba_season() - 1,
  season_segment = "",
  season_type = "Regular Season",
  vs_conference = "",
  vs_division = "",
  vs_player_id = "1629488",
  ...
)
}
\arguments{
\item{date_from}{date_from}

\item{date_to}{date_to}

\item{game_segment}{game_segment}

\item{last_n_games}{last_n_games}

\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{location}{location}

\item{measure_type}{measure_type}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{pace_adjust}{pace_adjust}

\item{per_mode}{per_mode}

\item{period}{period}

\item{player_id}{Player ID}

\item{plus_minus}{plus_minus}

\item{rank}{rank}

\item{season}{Season - format 2020-21}

\item{season_segment}{season_segment}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{vs_player_id}{vs_player_id}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: OnOffCourt, Overall, PlayerInfo, ShotAreaOffCourt,
ShotAreaOnCourt, ShotAreaOverall, ShotDistanceOffCourt, ShotDistanceOnCourt,
ShotDistanceOverall, VsPlayerInfo

\strong{Overall}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   WNBA_FANTASY_PTS \tab character \cr
}


\strong{OnOffCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   WNBA_FANTASY_PTS \tab character \cr
}


\strong{ShotDistanceOverall}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotDistanceOnCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GROUP_VALUE \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotDistanceOffCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GROUP_VALUE \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotAreaOverall}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotAreaOnCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GROUP_VALUE \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotAreaOffCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GROUP_VALUE \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{PlayerInfo}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   DISPLAY_FIRST_LAST \tab character \cr
   DISPLAY_LAST_COMMA_FIRST \tab character \cr
   DISPLAY_FI_LAST \tab character \cr
   BIRTHDATE \tab character \cr
   SCHOOL \tab character \cr
   COUNTRY \tab character \cr
   LAST_AFFILIATION \tab character \cr
}


\strong{VsPlayerInfo}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   DISPLAY_FIRST_LAST \tab character \cr
   DISPLAY_LAST_COMMA_FIRST \tab character \cr
   DISPLAY_FI_LAST \tab character \cr
   BIRTHDATE \tab character \cr
   SCHOOL \tab character \cr
   COUNTRY \tab character \cr
   LAST_AFFILIATION \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Player vs Player}

\strong{Get WNBA Stats API Player vs Player}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_playervsplayer(player_id = '1628932', vs_player_id = '1629488')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_playerawards}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playercompare}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerestimatedmetrics}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playerfantasyprofile}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamelog}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playerindex}()},
\code{\link{wnba_playernextngames}()},
\code{\link{wnba_playerprofilev2}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Player Functions}
