% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weco_rules.R
\docType{package}
\name{weco-package}
\alias{weco-package}
\title{Western Electric Company Rules (WECO) for Shewhart Control Chart}
\description{
Western Electric Company Rules (WECO) for Shewhart Control Chart
}
\section{Introduction}{


WECO rules got the name from the quality control hand book published by the
Western Electric Company in 1956. These rules detect the deviation from a
stable process by continuously testing data against predefined abnormal
patterns and have been accompanied with Shewhart control chart in statistical
process control.

There are eight commonly adopted abnormal patterns, namely, eight WECO rules.
It is of great interest to combine different WECO rules to increase the power
to detect deviation from a stable process. This package implements the
combination of multiple WECO rules.

Note that it is necessary to minimize the probability for making false alarms
when the process is in control. Running length is the first time at which a
process experiences out-of-control signals. The average running length (ARL)
is frequently used as a measure in statistical process control for evaluating
and comparing the performances of different methods.
}

\section{Rules}{


This package considers the following eight WECO rules:

\describe{

\item{Rule 1}{1 data point is greater than 3 standard deviation
from the center line. (This rule is to identify single data point that is out
of the acceptable range.)}

\item{Rule 2}{9 data points in a row on the same side of the center line.
(The ideal stable process is assumed to be up and down around the center
line. A large block of data points on the same side of the center line
indicates a process mean is shifted.)}

\item{Rule 3}{6 data points in a row, all increasing or decreasing. (This
rule is also an indicator of possible mean shift.)}

\item{Rule 4}{16 data points in a row, alternating up and down. (When data
points are routinely alternating up and down, it shows a high negative
correlation between neighboring observations, which is abnormal for a stable
process. For an in-control-process, it is not expected to observe correlation
between neighboring data points.)}

\item{Rule 5}{2 out of 3 data points on the same side are greater than 2
standard deviations from the center line. (For a normally distributed
in-control-process, about 95% of data points should be within 2 standard
deviation. The chance to violate this rule is 0.00306. This rule is used to
detect increase in process variation.)}

\item{Rule 6}{4 out of 5 data points on the same side are greater than 1
standard deviation from the center line. (For a normally distributed
in-control-process, about 62% of data points should be within 1 standard
deviation. This chance to violate this rule is 0.00553. This rule is also
used to detect increase in process variation.)}

\item{Rule 7}{15 data points in a row within 1 standard deviation of the
center line. (Too many data points are within 1 standard deviation indicates
the decrease in process variation.)}

\item{Rule 8}{8 data points in a row are greater than 1 standard deviation of
the center line. (This is another rule to detect increase in process
variance.)}

}
}

\section{Graphical user interface (GUI)}{


This package provides a web-based Shiny GUI. See \code{\link{run.weco}} for
details.
}
\references{
Introduction to Statistical Quality Control. Montgomery D.C. Third Edition.
Wiley, New York. 1996
}

