% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{drop_query}
\alias{drop_query}
\title{Drop the query and fragment from URL}
\usage{
drop_query(wt, varname = "url")
}
\arguments{
\item{wt}{webtrack data object.}

\item{varname}{character. name of the column from which to extract the host.
Defaults to \code{"url"}.}
}
\value{
webtrack data.frame with the same columns as wt
and a new column called \code{'<varname>_noquery'}
}
\description{
\code{drop_query()} adds the URL without query and fragment as a new column.
The query is defined as the part following a "?" after the path.
The fragement is anything following a "#" after the query.
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
# Extract URL without query/fragment
wt <- drop_query(wt)
}
}
