% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/splitters.R
\name{split_squid}
\alias{split_squid}
\title{split the "status_code" field in a Squid-formatted dataset.}
\usage{
split_squid(status_codes)
}
\arguments{
\item{status_codes}{a \code{status_code} column from a Squid file read in
with \code{\link{read_squid}}}
}
\value{
a data.frame of two columns - "squid_code" and "http_status" -
representing, respectively, the Squid response to the request and the
HTTP status of it.  In cases where the status code is not intact (containing,
for example, just the squid_code) a row of empty strings will currently be returned.
In the future, this will be somewhat improved.
}
\description{
the Squid data format (which can be read in with
\code{\link{read_squid}}) stores the squid response and the HTTP status
code as a single field. \code{\link{split_squid}} allows you to split
these into a data.frame of two distinct columns.
}
\examples{
#Read in an example Squid file provided with the webtools package, then split out the codes
data <- read_squid(system.file("extdata/log.squid", package = "webreadr"))
status_splot <- split_squid(data$status_code)
}
\seealso{
\code{\link{read_squid}} for reading these files in,
and \code{\link{split_clf}} for similar parsing of multi-field
columns in Common/Combined Log Format (CLF) data.
}

