% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestPattern.R
\docType{data}
\name{RequestPattern}
\alias{RequestPattern}
\title{RequestPattern class}
\arguments{
\item{method}{the HTTP method (any, head, options, get, post, put,
patch, trace, or delete). "any" matches any HTTP method. required.}

\item{uri}{(character) request URI. required or uri_regex}

\item{uri_regex}{(character) request URI as regex. required or uri}

\item{query}{(list) query parameters, optional}

\item{body}{(list) body request, optional}

\item{headers}{(list) headers, optional}
}
\description{
RequestPattern class
}
\details{
\strong{Methods}
\describe{
\item{\code{matches(request_signature)}}{
Test if request_signature matches a pattern
- request_signature: a request signature
}
\item{\code{to_s()}}{
Print pattern for easy human consumption
}
}
}
\examples{
\dontrun{
(x <- RequestPattern$new(method = "get", uri = "https://httpbin.org/get"))
x$body_pattern
x$headers_pattern
x$method_pattern
x$uri_pattern
x$to_s()

# make a request signature
rs <- RequestSignature$new(method = "get", uri = "https://httpbin.org/get")

# check if it matches
x$matches(rs)

# regex uri
(x <- RequestPattern$new(method = "get", uri_regex = ".+ossref.org"))
x$uri_pattern
x$uri_pattern$to_s()
x$to_s()

# uri with query parameters
(x <- RequestPattern$new(
    method = "get", uri = "https://httpbin.org/get",
    query = list(foo = "bar")
))
x$to_s()

# just headers (via setting method=any & uri_regex=.+)
headers <- list(
  'User-Agent' = 'Apple',
  'Accept-Encoding' = 'gzip, deflate', 
  'Accept' = 'application/json, text/xml, application/xml, */*')
x <- RequestPattern$new(
   method = "any",
   uri_regex = ".+",
   headers = headers)
x$to_s()
rs <- RequestSignature$new(method = "any", uri = "http://foo.bar", 
  options = list(headers = headers))
rs
x$matches(rs)
}
}
\seealso{
pattern classes for HTTP method \link{MethodPattern}, headers
\link{HeadersPattern}, body \link{BodyPattern}, and URI/URL \link{UriPattern}
}
\keyword{datasets}
