% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_compinfo}
\alias{cs_compinfo}
\title{Get record details (CSID, StdInChIKey, StdInChI, SMILES) by ChemSpider ID}
\usage{
cs_compinfo(csid, token, verbose = TRUE, ...)
}
\arguments{
\item{csid}{character, ChemSpider ID.}

\item{token}{character; security token.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a list of four, with entries: CSID (ChemSpider ID), InChI,
  InChIKey and SMILES string.
}
\description{
Get record details from ChemspiderId (CSID), see \url{http://www.chemspider.com/}
}
\note{
A security token is neeeded. Please register at RSC
\url{https://www.rsc.org/rsc-id/register}
for a security token.
}
\examples{
\dontrun{
# Fails because no TOKEN is included
token <- '<YOUR-SECURITY-TOKEN>'
# convert CAS to CSID
csid <- get_csid("Triclosan", token = token)
cs_compinfo(csid, token)

###
# multiple inputs
csids <- sapply(c('Aspirin', 'Triclosan'), get_csid, token = token)
# fails:
# cs_compinfo(csids, token = token)
(ll <- lapply(csids, cs_compinfo, token = token))
# return a list, convert to matrix:
do.call(rbind, ll)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link{get_csid}} to retrieve ChemSpider IDs,
\code{\link{csid_extcompinfo}} for extended compound information.
}

