% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assortativity.R
\name{dw_assort}
\alias{dw_assort}
\title{Compute the assortativity coefficient of a weighted and directed network.}
\usage{
dw_assort(adj, type = c("outin", "inin", "outout", "inout"))
}
\arguments{
\item{adj}{is an adjacency matrix of a weighted and directed network.}

\item{type}{which type of assortativity coefficient to compute: "outin"
(default), "inin", "outout" or "inout"?}
}
\value{
a scalar of assortativity coefficient
}
\description{
Compute the assortativity coefficient of a weighted and directed network.
}
\note{
When the adjacency matrix is binary (i.e., directed but unweighted
  networks), \code{dw_assort} returns the assortativity coefficient proposed
  in Foster et al. (2010).
}
\references{
\itemize{ \item Foster, J.G., Foster, D.V., Grassberger, P. and
  Paczuski, M. (2010). Edge direction and the structure of networks.
  \emph{Proceedings of the National Academy of Sciences of the United
  States}, 107(24), 10815--10820. \item Yuan, Y. Zhang, P. and Yan, J.
  (2021).
Assortativity coefficients for weighted and directed networks. \emph{Journal
of Complex Networks}, 9(2), cnab017. }
}
\keyword{internal}
