% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panet_control.R
\name{rpactl.edgeweight}
\alias{rpactl.edgeweight}
\title{Set parameters for controlling weight of new edges}
\usage{
rpactl.edgeweight(distribution = NA, dparams = list(), shift = 1)
}
\arguments{
\item{distribution}{Distribution function for edge weights. Default is
\code{NA}. If specified, its first argument must be the number of
observations.}

\item{dparams}{Additional parameters passed on to \code{distribution}. The
name of parameters must be specified.}

\item{shift}{A constant add to the specified distribution. Default value is
1.}
}
\value{
A list of class \code{rpactl} with components 
  \code{distribution}, \code{dparams}, and \code{shift} with meanings as 
  explained under 'Arguments'.
}
\description{
Set parameters for controlling weight of new edges
}
\examples{
# Edge weight follows Gamma(5, 0.2).
control <- rpactl.edgeweight(distribution = rgamma,
    dparams = list(shape = 5, scale = 0.2),
    shift = 0)

# Constant edge weight
control <- rpactl.edgeweight(shift = 2)

}
