% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sbs}
\alias{sbs}
\alias{sbs.default}
\title{Change-point detection via standard Binary Segmentation}
\usage{
sbs(x, ...)

\method{sbs}{default}(x, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{...}{not in use}
}
\value{
an object of class "sbs", which contains the following fields
\item{x}{the vector provided}
\item{n}{the length of \code{x}}
\item{res}{a 6-column matrix with results, where 's' and 'e' denote start-
end points of the intervals in which change-points candidates 'cpt' have been found;
column 'CUSUM' contains corresponding value of CUSUM statistic; 'min.th' is the smallest
threshold value for which given change-point candidate would be not added to the set of estimated
change-points; the last column is the scale at which the change-point has been found}
}
\description{
The function applies the Binary Segmentation algorithm to identify potential locations of the change-points in the mean of the input vector \code{x}.
The object returned by this routine can be further passed to the \code{\link{changepoints}} function,
which finds the final estimate of the change-points based on thresholding.
}
\examples{
x <- rnorm(300) + c(rep(1,50),rep(0,250))
s <- sbs(x)
s.cpt <- changepoints(s)
s.cpt
th <- c(s.cpt$th,0.7*s.cpt$th)
s.cpt <- changepoints(s,th=th)
s.cpt
}

