% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geotransform.R
\name{geotransform}
\alias{geotransform}
\title{geotransform}
\usage{
geotransform(decomp, geo, source = "decomposition")
}
\arguments{
\item{decomp}{the object from the decomposition or after deconvolution and decomposition.}

\item{geo}{the reference geolocation that is generally coming with waveform data and provided by the data provider.}

\item{source}{is determined by input data. If estimated parameters are from dcomposition, source = "decomposition". Otherwise will be deconvolution and decomposition.
Default is decomposition.}
}
\value{
A dataframe with columns. For the direct decompostion method, we will have 29 columns and for the deconvolution and decomposition method.
  17 columns were generated: index,pi,t,sd,pise,tse,sdse,px,py,pz,uncerUXpeak,uncerUYpeak,uncerUZpeak,uncerLXpeak,uncerLYpeak,uncerLZpeak,rn.
\item{\code{index}}{The index of waveform.}
\item{\code{pi}}{The estimated amplitude of an waveform componment.}
\item{\code{t}}{The estimated peak location of an waveform componment.}
\item{\code{sd}}{The estimated echo width of an waveform componment.}
\item{\code{pise}}{The standard error of the estimated amplitude.}
\item{\code{tse}}{The standard error of the estimated peak location.}
\item{\code{sdse}}{The standard error of the estimated echo width.}
\item{\code{px}}{Desired x position using peak locations.}
\item{\code{py}}{Desired y position using peak locations.}
\item{\code{pz}}{Desired y position using peak locations.}
\item{\code{lowx}}{Desired x position using leading edge locations.}
\item{\code{lowy}}{Desired y position using leading edge locations.}
\item{\code{lowz}}{Desired z position using leading edge locations.}
\item{\code{upx}}{Desired x position using trailing edge locations.}
\item{\code{upy}}{Desired y position using trailing edge locations.}
\item{\code{upz}}{Desired z position using trailing edge locations.}
\item{\code{uncerUXpeak}}{Upper bound of 95th confidence interval of px.}
\item{\code{uncerUYpeak}}{Upper bound of 95th confidence interval of py.}
\item{\code{uncerUZpeak}}{Upper bound of 95th confidence interval of pz.}
\item{\code{uncerLXpeak}}{Lower bound of 95th confidence interval of px.}
\item{\code{uncerLYpeak}}{Lower bound of 95th confidence interval of py.}
\item{\code{uncerLZpeak}}{Lower bound of 95thconfidence interval of pz.}
\item{\code{uncerUXleading}}{Upper bound of 95th confidence interval of lowx.}
\item{\code{uncerUYleading}}{Upper bound of 95th confidence interval of lowy.}
\item{\code{uncerUZleading}}{Upper bound of 95th confidence interval of lowz.}
\item{\code{uncerLXleading}}{Lower bound of 95th confidence interval of lowx.}
\item{\code{uncerLYleading}}{Lower bound of 95th confidence interval of lowy.}
\item{\code{uncerLZleading}}{Lower bound of 95th confidence interval of lowz.}
\item{\code{rn}}{The number of return for each waveform.}
By combining xyz, the users can get waveform-based point cloud using leading edge, peak and trail edge positions, and parameter uncertainty of the point cloud.
}
\description{
The function allows you to convert parameters from decomposition to point cloud by using georeference data (generally it should come with waveform data).
  Detailed description of how to calculate can refer to Zhou, T., Popescu, S.C., Krause, K., Sheridan, R.D., Putman, E., 2017.
  Gold - a noveldeconvolution algorithm with optimization for waveform LiDAR processing.ISPRS Journal of Photogrammetry and Remote Sensing 129 (2017): 131-150.
  For the direct decomposition method, three kinds of position are calculated: leading edge, peak and trail edge. For the deconvolution and decomposition method,
  only the peak position is used to calculate the position. In additional, the uncertianty of the point cloud was provided based on detected peaks'
  95% confidence interval using deterministic method for waveform decomposition. This fucntion is suitable for NEON waveform lidar. For other kinds of dataset,
  you need to preprocess data to the same format or have the same required information or datsets.
}
\examples{

data(geo)
data(decom_result)
data(decon_result)
##used part of data to show the results
decomp<-decom_result[1:80,]
geo<-geo[1:80]
deconp<-decon_result[1:80]

##the follwoing steps are reuired to conduct the geotransformation,
##we need assign exactly same column names
geoindex=c(1:9,16)
colnames(geo)[geoindex]<-c("index","orix","oriy","oriz","dx","dy","dz","outref","refbin","outpeak")
##for decomposition results

geor<-geotransform(decomp,geo)

########for deconvolution and decomposition
decongeo<-geotransform(decomp=deconp,geo,source="deconvolution")

}
\references{
Zhou, Tan*, Sorin C. Popescu, Keith Krause, Ryan D. Sheridan, and Eric Putman, 2017. Gold-A novel deconvolution algorithm with
  optimization for waveform LiDAR processing. ISPRS Journal of Photogrammetry and Remote Sensing 129 (2017):
  131-150. https://doi.org/10.1016/j.isprsjprs.2017.04.021
}
