% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperpointcloud.R
\name{hyperpointcloud}
\alias{hyperpointcloud}
\title{hyperpointcloud}
\usage{
hyperpointcloud(waveform, geo)
}
\arguments{
\item{waveform}{the raw waveform data.}

\item{geo}{the reference geolocation that corresponds to the raw waveform data which requres to have the same number of rows as the waveform data.}
}
\value{
A dataframe with 4 columns including xyz geolocation and intensity.
  \item{x}{The x position of one waveform intensity}
  \item{y}{The y position of one waveform intensity}
  \item{z}{The z position of one waveform intensity}
  \item{intensity}{The position's intensity}
}
\description{
The function allows you to convert every waveform intensities into points which formed hyper point cloud. This can help
  you visualize the waveform data in an efficient way. It will generate a big dataset which may reach the memory of computer's RAM.
  Thus, it requires to split the study regions into smaller tiles when you have large study sites.
}
\examples{

data(return)  ###import raw return waveforms
data(geo)  ###import corresponding reference geolocation
geo$index<- NULL
colnames(geo)[1:8]<- c("x","y","z","dx","dy","dz","or","fr")
### you should know which columns corresponding to above column names
### before run the hyperpointcloud when you used your own new datasets
hpr<- hyperpointcloud (waveform = return,geo = geo)
}
\references{
Zhou, Tan, Sorin Popescu, Lonesome Malambo, Kaiguang Zhao, and Keith Krause. From LiDAR 
  waveforms to Hyper Point Clouds: a novel data product to characterize vegetation structure. 
  Remote Sensing 10, no. 12 (2018): 1949.
}
