% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querxc.R
\name{querxc}
\alias{querxc}
\title{Access Xeno-Canto recordings and metadata}
\usage{
querxc(qword, download = FALSE, X = NULL, file.name = c("Genus", "Specific_epithet"), 
parallel = 1, path = NULL, pb = TRUE)
}
\arguments{
\item{qword}{Character vector of length one indicating the genus, or genus and
species, to query Xeno-Canto database. For example, \emph{Phaethornis} or \emph{Phaethornis longirostris}. 
(\url{http://www.xeno-canto.org/}).}

\item{download}{Logical argument. If \code{FALSE} only the recording file names and
associated metadata are downloaded. If \code{TRUE}, recordings are also downloaded to the working
directory as .mp3 files. Default is \code{FALSE}. Note that if the recording is already in the 
working directory (as when the downloading process has been interrupted) it will be skipped. 
Hence, resuming downloading processes will not start from scratch.}

\item{X}{Data frame with a 'Recording_ID' column and any other column listed in the file.name argument. Only the recordings listed in the data frame 
will be download (\code{download} argument is automatically set to \code{TRUE}). This can be used to select
the recordings to be downloaded based on their attributes.}

\item{file.name}{Character vector indicating the tags (or column names) to be included in the sound file names (if download = \code{TRUE}). Several tags can be included. If \code{NULL} only the Xeno-Canto recording identification number ("Recording_ID") is used. Default is c("Genus", "Specific_epithet").
Note that recording id is always used (whether or not is listed by users) to avoid duplicated names.}

\item{parallel}{Numeric. Controls whether parallel computing is applied when downloading mp3 files.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing). Might not work 
in Windows OS.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}. Note that progress bar is only used
when parallel = 1.}
}
\value{
If X is not provided the function returns a data frame with the following recording information: recording ID, Genus, Specific epithet, Subspecies, English name, Recordist, Country, Locality, Latitude, Longitude, Vocalization type, Audio file, License, URL, Quality, Time, Date. Sound files in .mp3 format are downloaded into the working directory if download = \code{TRUE} or if X is provided; a column indicating the  names of the downloaded files is included in the output data frame.
}
\description{
\code{querxc} downloads recordings and metadata from Xeno-Canto (\url{http://www.xeno-canto.org/}).
}
\details{
This function queries for avian vocalization recordings in the open-access
online repository Xeno-Canto (\url{http://www.xeno-canto.org/}). It can return recordings metadata
or download the associated sound files.
}
\examples{
\dontrun{
# First create empty folder
setwd(tempdir())

#search without downloading
df1 <- querxc(qword = "Phaethornis anthophilus", download = FALSE)
View(df1)

#downloading files
querxc(qword = "Phaethornis anthophilus", download = TRUE)
#check this folder!!
getwd()
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}

