% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_images.R
\name{move_images}
\alias{move_images}
\title{Move/copy image files between directories}
\usage{
move_images(
  from = NULL,
  to = NULL,
  it = "all",
  cut = TRUE,
  overwrite = FALSE,
  create.folder = TRUE,
  folder.name = "image_files",
  parallel = 1,
  pb = TRUE
)
}
\arguments{
\item{from}{Directory path where image files to be copied are found.
If \code{NULL} (default) then the current working directory is used.}

\item{to}{Directory path where image files will be copied to.}

\item{it}{A character vector of length 1 giving the image type to be used. "all",
"tiff", "jpeg" and "pdf" are admitted ("all" includes all the rest). Default is "all".}

\item{cut}{Logical. Determines if files are removed from the original location after
being copied (cut) or not (just copied). Default is \code{TRUE}.}

\item{overwrite}{Logical. Determines if files that already exist in the destination directory
should be overwritten. Default is \code{FALSE}.}

\item{create.folder}{Logical. Determines if files are moved to a new folder (which is named with the
"folder.name" argument). Ignored if 'to' is provided. Default is \code{TRUE}.}

\item{folder.name}{Character string with the name of the new folder where the files will be
copied to. Ignored if 'to' is provided. Default is \code{"image_files"}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
Image files moved into user-defined folders.
}
\description{
\code{move_images} moves/copies image files created by \href{https://cran.r-project.org/package=warbleR}{warbleR} between
directories (folders).
}
\details{
This function aims to simplify the manipulation of the image files generated by many
of the \href{https://cran.r-project.org/package=warbleR}{warbleR} function. It copies/cuts files between directories.
}
\examples{
{
  # load data
  data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))
  writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
  writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))

  # create spectrograms
  spectrograms(lbh_selec_table[1:5, ], path = tempdir(), pb = FALSE)

  # create folder to move image files
  dir.create(file.path(tempdir(), "imgs"))

  # copy files
  move_images(cut = FALSE, from = tempdir(), to = file.path(tempdir(), "imgs"))

  # cut files
  move_images(
    cut = TRUE, from = tempdir(),
    to = file.path(tempdir(), "imgs"), overwrite = TRUE
  )

  # Check this folder
  file.path(tempdir(), "imgs")
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{filter_sels}}

Other data manipulation: 
\code{\link{open_wd}()},
\code{\link{split_sound_files}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{data manipulation}
