% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/trackfreqs_1.4.R
\name{trackfreqs}
\alias{trackfreqs}
\title{Spectrograms with frequency measurements}
\usage{
trackfreqs(X, wl = 512, flim = c(0, 22), wn = "hanning", pal =
  reverse.gray.colors.2, ovlp = 70, inner.mar = c(5, 4, 4, 2) + 0.1, outer.mar =
  c(0, 0, 0, 0), picsize = 1, res = 100, cexlab = 1, title = TRUE, trel =
  FALSE, propwidth = FALSE, xl = 1, osci = FALSE, gr = FALSE, sc = FALSE,
  fmax = 12, bp = c(0, 22), cex = c(0.8, 1), threshold = 10, col =
  c("dodgerblue", "chartreuse3"), pch = c(16, 17),  mar = 0.05, lpos =
  "topright", it = "jpeg")
}
\arguments{
\item{X}{Data frame output from manualoc().}

\item{wl}{A number specifying the spectrogram window length, default is 512.}

\item{flim}{A numeric vector of length two for the frequency limit in kHz of
the spectrogram, as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{wn}{Character vector of length one specifying window name. Default is
"hanning", as in \code{\link[seewave]{spectro}}.}

\item{pal}{Color palette function for spectrogram. Default is
reverse.gray.colors.2.}

\item{ovlp}{Numeric vector of length one specifying % overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{inner.mar}{Numeric vector with 4 elements, default is c(5,4,4,2)+0.1.
Specifies number of lines in inner plot margins where axis labels fall,
with form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{outer.mar}{Numeric vector with 4 elements, default is c(0,0,0,0).
Specifies number of lines in outer plot margins beyond axis labels, with
form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{picsize}{Numeric argument of length one, controls relative size of
spectrogram. Default is 1.}

\item{res}{Numeric argument of length one, controls resolution of tiff image.
Default is 100 (faster) although 300 - 400 is recommended for publication/
presentation quality.}

\item{cexlab}{Numeric vector of length one, specifies relative size of axis
labels. See \code{\link[seewave]{spectro}}.}

\item{title}{Logical argument to add a title to individual spectrograms.
Default is TRUE.}

\item{trel}{Logical argument to add a time axis scale relative to the wave.
Default is FALSE.}

\item{propwidth}{Logical argument to scale the width of spectrogram
proportionally to duration of the selected call. Default is FALSE.}

\item{xl}{Numeric vector of length one, a constant by which to scale
spectrogram width if propwidth = TRUE. Default is 1.}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is FALSE.}

\item{gr}{Logical argument to add grid to spectrogram. Default is FALSE.}

\item{sc}{Logical argument to add amplitude scale to spectrogram, default is
FALSE.}

\item{fmax}{Numeric vector of length one, specifying the maximum for
frequency measurements. Default is 12 Hz.}

\item{bp}{A numeric vector of length two for the lower and upper limits of a
frequency bandpass filter (in kHz). Default is c(0, 22).}

\item{cex}{Numeric vector of length one, specifies relative size of points
plotted for frequency measurements and legend font/points, respectively.
See \code{\link[seewave]{spectro}}.}

\item{threshold}{\% amplitude threshold for fundamental frequency and
dominant frequency detection}

\item{col}{Vector of length two specifying colors of points plotted to mark
fundamental and dominant frequency measurements. Default is c("dodgerblue",
"chartreuse3").}

\item{pch}{Numeric vector of length two specifying plotting characters for
the frequency measurements. Default is c(16, 17).}

\item{mar}{Numeric vector of length one. Specifies the margins to subtract
from/add to start and end points of manualoc() selection, respectively,
dealineating spectrogram limits. Default is 0.05.}

\item{lpos}{Character vector of length one or numeric vector of length two,
specifiying position of legend. If the former, any keyword accepted by
xy.coords can be used. If the latter, the first value will be the x
coordinate and the second value the y coordinate for the legend's position.
Default is "topright".}

\item{it}{A character vector of length one giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}
}
\value{
Spectrograms per individual call marked with dominant and fundamental
  frequencies.
}
\description{
\code{trackfreqs} creates spectrograms to visualize dominant and fundametal frequency measurements.
}
\details{
This function provides visualization of two frequency measurements
  made by \code{specan}. Arguments that are accepted by xy.coords and can be
  used for lpos are: "bottomright", "bottom", "bottomleft", "left",
  "topleft", "top", "topright", "right" and "center". Setting inner.mar to
  c(4,4.5,2,1) and outer.mar to c(4,2,2,1) works well when picsize = 2 or 3.
  Title font size, inner.mar and outer.mar (from mar and oma) don't work well
  when osci or sc = TRUE, this may take some optimization by the user.
}
\examples{
\dontrun{
data(list = c("Arre.aura", "Phae.cuvi"))
data(manualoc.df)
writeWave(Arre.aura, "Arre.aura.wav") #save sound files
writeWave(Phae.cuvi, "Phae.cuvi.wav")

# make Arre.aura and Phae.cuvi spectrograms

trackfreqs(manualoc.df, flim = c(0, 14), inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1),
picsize = 2, res = 300, cexlab = 2, fmax = 14, bp = c(0, 14), cex = c(1.5, 2),
col = c("blue", "red"),  mar = 0.09, lpos = "bottomright", it = "jpeg")

# make only Arre.aura spectrograms

trackfreqs(manualoc.df[grepl(c("Arre"), manualoc.df$sound.files), ], flim = c(3, 14),
inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1), picsize = 2, res = 300, cexlab = 2,
fmax = 14, bp = c(3, 14), cex = c(1.5, 2), col = c("blue", "red"),  mar = 0.09,
lpos = "bottomright", it = "tiff")
}
}
\author{
Grace Smith Vidaurre and Marcelo Araya-Salas (http://marceloarayasalas.weebly.com)
}
\seealso{
\code{\link{specreator}} for creating spectrograms after
  \code{manualoc}, \code{\link{snrspecs}} for creating spectrograms to
  optimize noise margins used in \code{sig2noise}

Other spectrogram.creators: \code{\link{snrspecs}};
  \code{\link{specreator}}
}

