% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare two objects}
\usage{
compare(
  x,
  y,
  ...,
  x_arg = "x",
  y_arg = "y",
  tolerance = NULL,
  ignore_srcref = TRUE,
  ignore_attr = FALSE,
  ignore_encoding = TRUE,
  ignore_function_env = FALSE,
  ignore_formula_env = FALSE
)
}
\arguments{
\item{x, y}{Objects to compare. \code{y} is treated as the reference object
so messages describe how \code{x} is different to \code{y}}

\item{...}{A handful of other arguments are supported with a warning for
backward compatability. These include:
\itemize{
\item \code{all.equal()} arguments \code{checkNames} and \code{check.attributes}
\item \code{testthat::compare()} argument \code{tol}
}

All other arguments are ignored with a warning.}

\item{x_arg, y_arg}{Name of \code{x} and \code{y} arguments, used when generated paths
to internal components.}

\item{tolerance}{If non-\code{NULL}, used as threshold for ignoring small
floating point difference when comparing numeric vectors. Setting to
any non-\code{NULL} value will cause integer and double vectors to be compared
based on their values, rather than their types.

It uses the same algorithm as \code{\link[=all.equal]{all.equal()}}, i.e., first we generate
\code{x_diff} and \code{y_diff} by subsetting \code{x} and \code{y} to look only locations
with differences. Then we check that
\code{mean(abs(x_diff - y_diff)) / mean(abs(y_diff))} (or just
\code{mean(abs(x_diff - y_diff))} if \code{y_diff} is small) is less than
\code{tolerance}.}

\item{ignore_srcref}{Ignore differences in function \code{srcref}s? \code{TRUE} by
default since the \code{srcref} does not change the behaviour of a function,
only its printed representation.}

\item{ignore_attr}{Ignore all differences in attributes? Only provided
for backward compatibility with \code{all.equal()}. Using \code{TRUE} is not
generally recommended because it will ignore many important functional
differences.}

\item{ignore_encoding}{Ignore string encoding? \code{TRUE} by default, because
this is R's default behaviour. Use \code{FALSE} when specifically concerned
with the encoding, not just the value of the string.}

\item{ignore_function_env, ignore_formula_env}{Ignore the environments of
functions and formulas, respectively? These are provided primarily for
backward compatibility with \code{all.equal()} which always ignores these
environments.}
}
\value{
A character vector with class "waldo_compare". If there are no
differences it will have length 0; otherwise each element is contains
the description of a single difference.
}
\description{
This compares two R objects, identifying the key differences. It:
\itemize{
\item Orders the differences from most important to least important.
\item Displays the values of atomic vectors that are actually different.
\item Carefully uses colour to emphasise changes (while still being readable
when colour isn't available).
\item Uses R code (not a text description) to show where differences arise.
\item Where possible, it compares elements by name, rather than by position.
\item Errs on the side of producing too much output, rather than too little.
}

\code{compare()} is an alternative to \code{\link[=all.equal]{all.equal()}}.
}
\examples{
# Thanks to diffobj package comparison of atomic vectors shows differences
# with a little context
compare(letters, c("z", letters[-26]))
compare(c(1, 2, 3), c(1, 3))
compare(c(1, 2, 3), c(1, 3, 4, 5))
compare(c(1, 2, 3), c(1, 2, 5))

# More complex objects are traversed, stopping only when the types are
# different
compare(
  list(x = list(y = list(structure(1, z = 2)))),
  list(x = list(y = list(structure(1, z = "a"))))
)

# Where possible, recursive structures are compared by name
compare(iris, rev(iris))

compare(list(x = "x", y = "y"), list(y = "y", x = "x"))
# Otherwise they're compared by position
compare(list("x", "y"), list("x", "z"))
compare(list(x = "x", x = "y"), list(x = "x", y = "z"))
}
