% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_heat.R
\name{table_heat}
\alias{table_heat}
\title{View Data Table Column Types as Heat Map}
\usage{
table_heat(x, flip = FALSE, palette = "Set3", print = interactive(),
  sep = "\\n")
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}}.}

\item{flip}{logical.  If \code{TRUE} the \code{\link[base]{data.frame}} is
flipped so that the columns are on the y axis and observations on the x axis.
This is useful when there are many columns or the column names are longer.}

\item{palette}{A palette to chose from.  See
\code{\link[ggplot2]{scale_fill_brewer}} for more.  These choices should
exceed the number of unique column types. Use \code{NULL} to use
\pkg{ggplot2}'s default color scheme.}

\item{print}{logical.  If \code{TRUE} the pot is printed.  Option for use in
document construction such as \pkg{knitr} or \pkg{rmarkdown}.}

\item{sep}{A separator to use between column types.  Column types are
determined via \code{sapply(x, class)}.  When multiple types are present
these are collapsed.  By default the \code{\\n} is used.}
}
\value{
Returns a \pkg{ggplot2} object.
}
\description{
Generate a heat map of column types from a \code{\link[base]{data.frame}}.
}
\details{
By default coumn names retain their order.  Column types are ordered
alphabetically in the legend, with \code{NA} appearing last.
}
\examples{
table_heat(mtcars) #boring
table_heat(CO2)
table_heat(iris)
table_heat(state_populations)

dat <- r_data_frame(100,
    lorem_ipsum,
    birth,
    animal,
    age,
    grade, grade,
    death,
    dummy,
    grade_letter
)

table_heat(dat)
table_heat(dat, flip=TRUE)

table_heat(r_data_theme(), flip=TRUE)

## NA values
table_heat(r_na(dat, NULL))

## Colors
table_heat(r_na(dat, NULL), palette = NULL)
table_heat(r_na(dat, NULL), palette = "Set1")
table_heat(r_na(dat, NULL), palette = "Set2")
table_heat(r_na(dat, NULL), palette = "Set1")
table_heat(r_na(dat, NULL), palette = "Dark2")
table_heat(r_na(dat, NULL), palette = "Spectral")
table_heat(r_na(dat, NULL), palette = "Reds")
}
\keyword{class,}
\keyword{type}
