% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hair.R
\name{hair}
\alias{hair}
\title{Generate Random Vector of Hair Colors}
\usage{
hair(n, x = c("Brown", "Black", "Blonde", "Red"), prob = c(0.35, 0.28, 0.26,
  0.11), name = "hair")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random vector of hair color elements.
}
\description{
Generate a random vector of hair colors.
}
\details{
The hair colors and probabilities:

\tabular{lr}{
  \bold{ Color}     \tab \bold{Percent}\cr
  Brown   \tab 35 \%\cr
  Black   \tab 28 \%\cr
  Blonde  \tab 26 \%\cr
  Red     \tab 11 \%\cr
}
}
\examples{
hair(10)
v <- table(hair(10000))
lbs <- paste0(names(v), "\\n", round(100*v/sum(v), 1), "\%")
pie(v, col = replace(names(v), 3, "yellow"), labels = lbs)
}
\seealso{
Other variable functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dob}},
  \code{\link{dummy}}, \code{\link{education}},
  \code{\link{employment}}, \code{\link{eye}},
  \code{\link{grade_level}}, \code{\link{grade}},
  \code{\link{group}}, \code{\link{height}},
  \code{\link{income}}, \code{\link{internet_browser}},
  \code{\link{iq}}, \code{\link{language}},
  \code{\link{level}}, \code{\link{likert}},
  \code{\link{lorem_ipsum}}, \code{\link{marital}},
  \code{\link{military}}, \code{\link{month}},
  \code{\link{name}}, \code{\link{normal}},
  \code{\link{political}}, \code{\link{race}},
  \code{\link{religion}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{hair}
