% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/religion.R
\name{religion}
\alias{religion}
\title{Generate Random Vector of Religions}
\usage{
religion(n, x = c("Christian", "Muslim", "None", "Hindu", "Buddhist", "Folk",
  "Other", "Jewish"), prob = c(0.31477, 0.23163, 0.16323, 0.14985, 0.07083,
  0.05882, 0.00859, 0.00227), name = "Religion")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random factor vector of religion elements.
}
\description{
Generate a random vector of religion.
}
\details{
The religion and probabilities used match approximate world
religion make-up (from \href{http://www.pewforum.org/}{Pew Research Center}).  
The default make up is:

\tabular{lrr}{
  \bold{ Religion} \tab \bold{N} \tab \bold{Percent} \cr
  Christian \tab 2,173,260,000 \tab 31.48 \%\cr
  Muslim    \tab 1,599,280,000 \tab 23.16 \%\cr
  None      \tab 1,127,000,000 \tab 16.32 \%\cr
  Hindu     \tab 1,034,620,000 \tab 14.99 \%\cr
  Buddhist  \tab   489,030,000 \tab 7.08 \% \cr
  Folk      \tab   406,140,000 \tab 5.88 \% \cr
  Other     \tab    59,330,000 \tab  .86 \% \cr
  Jewish    \tab    15,670,000 \tab  .23 \% \cr
}
}
\examples{
religion(10)
barplot(table(religion(10000)))
pie(table(religion(10000)))
}
\references{
\url{http://www.pewforum.org/2012/12/18/table-religious-composition-by-country-in-numbers}
}
\seealso{
Other variable.functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dob}},
  \code{\link{dummy}}, \code{\link{education}},
  \code{\link{employment}}, \code{\link{eye}},
  \code{\link{grade_level}}, \code{\link{grade}},
  \code{\link{group}}, \code{\link{hair}},
  \code{\link{height}}, \code{\link{income}},
  \code{\link{internet_browser}}, \code{\link{iq}},
  \code{\link{language}}, \code{\link{level}},
  \code{\link{likert}}, \code{\link{lorem_ipsum}},
  \code{\link{marital}}, \code{\link{military}},
  \code{\link{month}}, \code{\link{name}},
  \code{\link{normal}}, \code{\link{political}},
  \code{\link{race}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{religion}

