% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_course_users.R
\name{get_course_users}
\alias{get_course_users}
\title{Retrieves the users in a course.}
\usage{
get_course_users(
  canvas,
  course_id,
  per_page = 100,
  include = c("enrollments", "locked", "avatar_url", "test_student", "bio",
    "custom_links", "current_grading_period_scores", "uuid")
)
}
\arguments{
\item{canvas}{An object containing the Canvas API key and base URL, obtained through the \code{canvas_authenticate} function.}

\item{course_id}{The ID of the course for which to fetch the users.}

\item{per_page}{The number of entries to show per page.}

\item{include}{Optional parameters to include in the response. Possible values: "enrollments", "locked", "avatar_url", "test_student", "bio", "custom_links", "current_grading_period_scores", "uuid".}
}
\value{
A data frame containing the users in the specified course.
}
\description{
This function retrieves the users enrolled in a specific course in the Canvas LMS API.
}
