% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/per_DR_basis.R
\name{DR.basis}
\alias{DR.basis}
\title{Periodic Demmler-Reinsch Basis}
\usage{
DR.basis(x, n, q)
}
\arguments{
\item{x}{\code{m}-dim. vector with grid values in [0,1]}

\item{n}{dimension of the basis}

\item{q}{penalization order, \code{q=1,2,3,4} are available}
}
\value{
\code{mxn} dimensional matrix with the \code{n} DR basis functions evaluated at grid points \code{x}
}
\description{
Calculates the periodic Demmler-Reinsch basisfor a given smoothness and a given vector of grid points. For details see (Schwarz, Krivobokova; 2016).
}
\examples{
DR.basis(seq(1,10)/10,5,2)
}
