% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vroom_fwf.R
\name{vroom_fwf}
\alias{vroom_fwf}
\alias{fwf_empty}
\alias{fwf_widths}
\alias{fwf_positions}
\alias{fwf_cols}
\title{Read a fixed width file into a tibble}
\usage{
vroom_fwf(file, col_positions = fwf_empty(file[[1]], skip, n =
  guess_max), col_types = NULL, col_select = NULL, id = NULL,
  locale = default_locale(), na = c("", "NA"), comment = "",
  trim_ws = TRUE, skip = 0, n_max = Inf, guess_max = 100,
  num_threads = vroom_threads(), progress = vroom_progress(),
  .name_repair = "unique")

fwf_empty(file, skip = 0, col_names = NULL, comment = "", n = 100L)

fwf_widths(widths, col_names = NULL)

fwf_positions(start, end = NULL, col_names = NULL)

fwf_cols(...)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path) or be a
vector of greater than length 1.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{col_positions}{Column positions, as created by \code{\link[=fwf_empty]{fwf_empty()}},
\code{\link[=fwf_widths]{fwf_widths()}} or \code{\link[=fwf_positions]{fwf_positions()}}. To read in only selected fields,
use \code{\link[=fwf_positions]{fwf_positions()}}. If the width of the last column is variable (a
ragged fwf file), supply the last end position as NA.}

\item{col_types}{One of \code{NULL}, a \code{\link[=cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be imputed from the first 1000 rows
on the input. This is convenient (and fast), but not robust. If the
imputation fails, you'll need to supply the correct types yourself.

If a column specification created by \code{\link[=cols]{cols()}}, it must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[=cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
c = character, i = integer, n = number, d = double,
l = logical, f = factor, D = date, T = date time, t = time, ? = guess, or
\code{_}/\code{-} to skip the column.}

\item{col_select}{One or more selection expressions, like in
\code{dplyr::select()}. Use \code{c()} or \code{list()} to use more than one expression.
See \code{?dplyr::select} for details on available selection options.}

\item{id}{Either a string or 'NULL'. If a string, the output will contain a
variable with that name with the filename(s) as the value. If 'NULL', the
default, no variable will be created.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{trim_ws}{Should leading and trailing whitespace be trimmed from
each field before parsing it?}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{guess_max}{Maximum number of records to use for guessing column types.}

\item{num_threads}{Number of threads to use when reading and materializing vectors.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}

\item{.name_repair}{Handling of column names. By default, vroom ensures
column names are not empty and unique. See \code{.name_repair} as documented in
\code{\link[tibble:tibble]{tibble::tibble()}} for additional options including supplying user defined
name repair functions.}

\item{col_names}{Either NULL, or a character vector column names.}

\item{n}{Number of lines the tokenizer will read to determine file structure. By default
it is set to 100.}

\item{widths}{Width of each field. Use NA as width of last field when
reading a ragged fwf file.}

\item{start, end}{Starting and ending (inclusive) positions of each field.
Use NA as last end field when reading a ragged fwf file.}

\item{...}{If the first element is a data frame,
then it must have all numeric columns and either one or two rows.
The column names are the variable names. The column values are the
variable widths if a length one vector, and if length two, variable start and end
positions. The elements of \code{...} are used to construct a data frame
with or or two rows as above.}
}
\description{
Read a fixed width file into a tibble
}
\examples{
fwf_sample <- vroom_example("fwf-sample.txt")
cat(readLines(fwf_sample))

# You can specify column positions in several ways:
# 1. Guess based on position of empty columns
vroom_fwf(fwf_sample, fwf_empty(fwf_sample, col_names = c("first", "last", "state", "ssn")))
# 2. A vector of field widths
vroom_fwf(fwf_sample, fwf_widths(c(20, 10, 12), c("name", "state", "ssn")))
# 3. Paired vectors of start and end positions
vroom_fwf(fwf_sample, fwf_positions(c(1, 30), c(20, 42), c("name", "ssn")))
# 4. Named arguments with start and end positions
vroom_fwf(fwf_sample, fwf_cols(name = c(1, 20), ssn = c(30, 42)))
# 5. Named arguments with column widths
vroom_fwf(fwf_sample, fwf_cols(name = 20, state = 10, ssn = 12))
}
