% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{generators}
\alias{generators}
\alias{gen_character}
\alias{gen_double}
\alias{gen_number}
\alias{gen_integer}
\alias{gen_factor}
\alias{gen_time}
\alias{gen_date}
\alias{gen_datetime}
\alias{gen_logical}
\alias{gen_name}
\title{Generate individual vectors of the types supported by vroom}
\usage{
gen_character(n, min = 5, max = 25, values = c(letters, LETTERS,
  0:9), ...)

gen_double(n, f = stats::rnorm, ...)

gen_number(n, f = stats::rnorm, ...)

gen_integer(n, min = 1L, max = .Machine$integer.max, prob = NULL,
  ...)

gen_factor(n, levels = NULL, ordered = FALSE,
  num_levels = gen_integer(1L, 1L, 25L), ...)

gen_time(n, min = 0, max = hms::hms(days = 1), fractional = FALSE,
  ...)

gen_date(n, min = as.Date("2001-01-01"), max = as.Date("2021-01-01"),
  ...)

gen_datetime(n, min = as.POSIXct("2001-01-01"),
  max = as.POSIXct("2021-01-01"), tz = "UTC", ...)

gen_logical(n, ...)

gen_name(n)
}
\arguments{
\item{n}{The size of the vector to generate}

\item{min}{The minimum range for the vector}

\item{max}{The maximum range for the vector}

\item{values}{The explicit values to use.}

\item{...}{Additional arguments passed to internal generation functions}

\item{f}{The random function to use.}

\item{prob}{a vector of probability weights for obtaining the elements
    of the vector being sampled.}

\item{levels}{The explicit levels to use, if \code{NULL} random levels are generated using \code{\link[=gen_name]{gen_name()}}.}

\item{ordered}{Should the factors be ordered factors?}

\item{num_levels}{The number of factor levels to generate}

\item{fractional}{Whether to generate times with fractional seconds}

\item{tz}{The timezone to use for dates}
}
\description{
Generate individual vectors of the types supported by vroom
}
\examples{
# characters
gen_character(4)

# factors
gen_factor(4)

# logical
gen_logical(4)

# numbers
gen_double(4)
gen_integer(4)

# temporal data
gen_time(4)
gen_date(4)
gen_datetime(4)
}
