% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsenate.r
\name{senate_carto}
\alias{senate_carto}
\title{Produce a Senate cartogram}
\usage{
senate_carto(vote_tally)
}
\arguments{
\item{vote_tally}{either a \code{pprc} object (the result of a call to \code{\link[=roll_call]{roll_call()}}) or
a \code{data.frame} of vote tallies for the senate. It expects 3 columns. \code{state_abbrev} : the
2-letter U.S. state abbreviation; \code{district} : either \code{1} or \code{2} to distinguish between
each senator; \code{party} : \code{R}, \code{D} or \code{ID}; \code{position} : \code{yes}, \code{no}, \code{present}, \code{none} for
how the senator voted.}
}
\value{
a \code{ggplot2} object that you can further customize with scales, labels, etc.
}
\description{
Produce a Senate cartogram
}
\note{
No "themeing" is applied to the returned ggplot2 object. You can use  \code{\link[=theme_voteogram]{theme_voteogram()}}
if you need a base theme.
}
\examples{
\dontrun{
# what you'd normally do
sen <- roll_call("senate", 115, 1, 110)
}

# Using a saved object
sen <- readRDS(system.file("extdata", "sen.rds", package="voteogram"))

senate_carto(sen)
}
