% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.evppi}
\alias{plot.evppi}
\title{Plot EVPPI estimates}
\usage{
\method{plot}{evppi}(x, type = NULL, order = FALSE, top = NULL, ...)
}
\arguments{
\item{x}{Object returned from \code{\link{evppi}}.}

\item{type}{\code{"dots"} for a dot plot of the EVPPI by parameter.  If \code{x} includes multiple
willingness-to-pay values for the same parameter, these are shown as multiple dots.

\code{"curves"} for a plot of EVPPI against willingness-to-pay, with different
parameters distinguished as different curves.  This is only applicable if there
are multiple willingness-to-pay values included in \code{x}.}

\item{order}{For dot plots, order the plot with highest EVPPI values at the top.}

\item{top}{A positive integer. If specified, for example as \code{top=5} then only
five parameters are included in the plot, those with the top five maximum EVPPI
values by parameter.}

\item{...}{Other arguments (currently unused).}
}
\value{
A \code{ggplot2} object.
}
\description{
Plot EVPPI estimates as simple dot or curve plots.
}
\details{
These plotting functions are intended for quick interactive exploration of
EVPPI results, so they deliberately have limited options for customising them.

For publication quality graphics, it is advised to use \code{ggplot2} by hand
on the data returned by \code{evppi}.   Examine the code for \code{plot_evppi_dots}
and \code{plot_evppi_curves} to see how these plots might be constructed.
}
