% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_sim.R
\name{racusum_crit_sim}
\alias{racusum_crit_sim}
\title{Compute alarm threshold of RA-CUSUM control charts using simulation}
\usage{
racusum_crit_sim(
  L0,
  pmix,
  RA = 2,
  RQ = 1,
  yemp = FALSE,
  m = 10000,
  nc = 1,
  hmax = 30,
  jmax = 4,
  verbose = FALSE
)
}
\arguments{
\item{L0}{Double. Prespecified in-control Average Run Length.}

\item{pmix}{Data Frame. A three column data frame. First column is the operation outcome.
Second column are the predicted probabilities from the risk model. Third column can be either the
 predicted probabilities from the risk model or average outcome.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}. Odds ratio of death under the null hypotheses is \code{1}.}

\item{RQ}{Double. Defines the true performance of a surgeon with the odds ratio ratio of death
\code{RQ}. Use \code{RQ = 1} to compute the in-control ARL and other values to compute the
out-of-control ARL.}

\item{yemp}{Logical. If \code{TRUE}, use emirical outcome values, else use model.}

\item{m}{Integer. Number of simulation runs.}

\item{nc}{Integer. Number of cores used for parallel processing. Value is passed to
\code{\link{parSapply}}.}

\item{hmax}{Integer. Maximum value of \code{h} for the grid search.}

\item{jmax}{Integer. Number of digits for grid search.}

\item{verbose}{Logical. If \code{TRUE} verbose output is included, if \code{FALSE} a quiet
calculation of \code{h} is done.}
}
\value{
Returns a single value which is the control limit \code{h} for a given in-control ARL.
}
\description{
Compute alarm threshold of risk-adjusted cumulative sum control charts using
 simulation.
}
\details{
Determines the control limit ("\code{h}") for given in-control ARL (\code{"L0"})
applying a grid search using \code{\link{racusum_arl_sim}} and \code{\link{parSapply}}.
}
\examples{
\dontrun{
library(vlad)
library(dplyr)
data("cardiacsurgery", package = "spcadjust")

## preprocess data to 30 day mortality
SALL <- cardiacsurgery \%>\% rename(s = Parsonnet) \%>\%
  mutate(y = ifelse(status == 1 & time <= 30, 1, 0),
         phase = factor(ifelse(date < 2*365, "I", "II")))
SI <- subset(SALL, phase == "I")
y <- subset(SALL, select = y)
GLM <- glm(y ~ s, data = SI, family = "binomial")
pi1 <- predict(GLM, type = "response", newdata = data.frame(s = SALL$s))
pmix <- data.frame(y, pi1, pi1)
h <- racusum_crit_sim(pmix = pmix, L0 = 370, RA = 2, nc = 4, verbose = TRUE)
}
}
\references{
Steiner SH, Cook RJ, Farewell VT and Treasure T (2000).
 Monitoring surgical performance using risk-adjusted cumulative sum charts.
 \emph{Biostatistics}, \strong{1}(4), pp. 441--452.

Wittenberg P, Gan FF, Knoth S (2018).
A simple signaling rule for variable life-adjusted display derived from
an equivalent risk-adjusted CUSUM chart.
\emph{Statistics in Medicine}, \strong{37}(16), pp 2455--2473.
}
\author{
Philipp Wittenberg
}
