% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/australia.R
\name{aus_fertility}
\alias{aus_fertility}
\title{Australian fertility data}
\format{
Time series of class \code{vital}
}
\source{
Australian Human Mortality Database. \url{https://aushd.org}
}
\description{
\code{aus_fertility} is an annual \code{vital} object covering the years 1921-2002 with three values:
\tabular{ll}{
Fertility: \tab Fertility rate per woman \cr
Exposure:  \tab Population of women at 30 June each year\cr
Births:    \tab Number of births \cr
}
}
\details{
The data is disaggregated using one key:
\tabular{ll}{
Age: \tab Age of mother at time of birth\cr
}
The extreme age groups (15 and 49) also include a few younger and older mothers respectively.
}
\examples{
library(ggplot2)
aus_fertility
aus_fertility |>
  autoplot(Fertility) +
  ylab("Fertility rate")

}
\keyword{datasets}
