% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csl_date.R
\name{csl_date}
\alias{csl_date}
\alias{csl_dates}
\title{A date conforming to the CSL schema}
\usage{
csl_date(
  date_parts = list(),
  season = NULL,
  circa = NULL,
  literal = NULL,
  raw = NULL,
  edtf = NULL
)

csl_dates(x = list())
}
\arguments{
\item{date_parts}{A list containing one or two dates in a list. Each date is
also represented using lists in the format of \code{list(year, month, day)}.
Different precision can be achieved by providing an incomplete list:
\code{list(year, month)}. A range of dates can be specified by providing two
dates, where the first date is the start and second date is the end of the
interval.}

\item{season, circa, literal, raw, edtf}{Additional date variable properties as
described in the schema.}

\item{x}{A list of \code{csl_date()} values.}
}
\description{
This class provides helper utilities to display, sort, and select attributes
from a date in the CSL format.
}
\examples{
# Single date
csl_date(date_parts = list(list(2020,03,05)))
# Date interval
csl_date(date_parts = list(list(2020,03,05), list(2020,08,25)))

}
\seealso{
\url{https://citeproc-js.readthedocs.io/en/latest/csl-json/markup.html#date-fields}
}
