% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{cluster_boxplots}
\alias{cluster_boxplots}
\title{Plot boxplots with clusters}
\usage{
cluster_boxplots(annotated_data, ...)
}
\arguments{
\item{annotated_data}{data frame returned by \code{annotate_clusters()}}

\item{...}{arguments passed to \code{facet_boxplot()}}
}
\value{
boxplots faceted by clusters
}
\description{
This is a convenience wrapper function for \code{facet_boxplot()}.
Combined with \code{annotate_clusters()}, it
doesn't require specifying axes in \code{facet_boxplot()}.
}
\examples{
dmat <- compute_dmat(iris, "euclidean", TRUE, c("Petal.Length", "Sepal.Length"))
clusters <- compute_clusters(dmat, "complete")
cluster_labels <- cut_clusters(clusters, 2)
annotated_data <- annotate_clusters(iris[, c("Petal.Length", "Sepal.Length")], cluster_labels)
cluster_boxplots(annotated_data, boxplot_colors = visxhclust::cluster_colors)
}
