% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/viridis.R
\name{viridis}
\alias{viridis}
\alias{viridisMap}
\title{Matplotlib 'viridis' color map}
\usage{
viridis(n, alpha = 1)

viridisMap(n = 256, alpha = 1)
}
\arguments{
\item{n}{The number of colors (\eqn{\ge 1}) to be in the palette.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}
}
\value{
\code{viridis} returns a character vector, \code{cv}, of color hex
codes. This can be used either to create a user-defined color palette for
subsequent graphics by \code{palette(cv)}, a \code{col =} specification in
graphics functions or in \code{par}.

\code{viridisMap} returns a \code{n} lines data frame containing the
red (\code{R}), green (\code{G}), blue (\code{B}) and alpha (\code{alpha})
channels of \code{n} equally spaced colors along the 'viridis' color map.
\code{n = 256} by default, which corresponds to the data from the original
'viridis' color map in Matplotlib.
}
\description{
This function creates a vector of \code{n} equally spaced colors along the
Matplolib 'viridis' color map created by \href{https://github.com/stefanv}{Stéfan van der Walt}
and \href{https://github.com/njsmith}{Nathaniel Smith}. This color map is
designed in such a way that it will analytically be perfectly perceptually-uniform,
both in regular form and also when converted to black-and-white. It is also
designed to be perceived by readers with the most common form of color blindness.
}
\details{
Semi-transparent colors (\eqn{0 < alpha < 1}) are supported only on some
devices: see \code{\link[grDevices]{rgb}}.
}
\examples{
library(ggplot2)
library(hexbin)

dat <- within(data.frame(x = rnorm(10000), y = rnorm(10000)), {
  Distance <- sqrt(x^2 + y^2)
})

ggplot(dat, aes(x = x, y = y)) +
  geom_hex() + coord_fixed() +
  scale_fill_gradientn(colours = viridis(256))
}
\author{
Simon Garnier: \email{garnier@njit.edu}, \href{https://twitter.com/sjmgarnier}{@sjmgarnier}
}

