#' Predictive Modeling Data for Viral Load and CD4 Lymphocyte Counts
#'
#' This dataset serves as input for predictive modeling tasks related to HIV
#' research. It contains numeric measurements of CD4 lymphocyte counts (cd) and
#' viral load (vl) at three different time points: 2019, 2021, and 2022. These
#' measurements are crucial indicators of HIV disease progression.
#'
#' @docType data
#'
#' @usage data(viral)
#'
#' @format A tibble (data frame) with 35 rows and 6 columns.
#'
#' @keywords datasets
#'
#' @note
#' To explore more rows of this dataset, you can use the `print(n = ...)` function.
#'
#' @author
#' Juan Pablo Acuña González <22253567@uagro.mx>
#'
#' @examples
#' data(viral)
#' viral
"viral"
